function u=valutafieldP2(t,y,vertices,elements,bxmin,bymin,bxmax,bymax,field)
%VALUTAFIELDP2 evaluate a P2 function on a set of nodes.
%   VALUES=VALUTAFIELDP2(T,NODES,VERTICES,ELEMENTS,BXMIN,BYMIN,BXMAX,BYMAX,FIELD)
%   computes the values VALUES of the P2 vector function FIELD on the nodes NODES.
%   BXMIN, BYMIN, BXMAX, BYMAX are the extrema of the bounding-boxes of eac
%   elements ELEMENTS of the mesh which vertices are given in VERTICES.
%   The first input parameter T is due to the fact that this function can
%   be used in connection with the Matlab's ODE solvers.

%       F. Saleri 26-01-03.

ly = length(y);
xfoot = y(1:ly/2);
yfoot = y(ly/2+1:end);
[nov,n]=size(field);
nov = nov/2;
ux = field(1:nov);
uy = field(nov+1:end);
v=findnodes(vertices,elements,xfoot,yfoot,bxmin,bymin,bxmax,bymax);
phi = zeros(6,1);
for i = 1:ly/2
    element_index = v(i,1);
    if isnan(element_index)
        uxfoot(i) = 0;
        uyfoot(i) = 0;
    else
        ee = elements(1:6,element_index);
        phi=P2ref(v(i,3),v(i,4),phi);
        uxfoot(i) = phi(1,1)*ux(ee(1))+phi(2,1)*ux(ee(2))+phi(3,1)*ux(ee(3))+...
            phi(4,1)*ux(ee(4))+phi(5,1)*ux(ee(5))+phi(6,1)*ux(ee(6));
        uyfoot(i) = phi(1,1)*uy(ee(1))+phi(2,1)*uy(ee(2))+phi(3,1)*uy(ee(3))+...
            phi(4,1)*uy(ee(4))+phi(5,1)*uy(ee(5))+phi(6,1)*uy(ee(6));
    end
end
u = [uxfoot'; uyfoot'];

%figure(4); quiver(xfoot,yfoot,uxfoot,uyfoot); hold on; pause
return

function phi=P2ref(xi,yi,phi)

phi(1,1) = (1-xi-yi)*(1-2*xi-2*yi);
phi(2,1) = xi*(-1+2*xi);
phi(3,1) = yi*(-1+2*yi);
phi(4,1) = 4*xi*(1-xi-yi);
phi(5,1) = 4*xi*yi;
phi(6,1) = 4*yi*(1-xi-yi);

return